/***************************************************************************
*
* Copyright 2010,2011 BMW Car IT GmbH
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/

#ifndef _SURFACECREATECOMMAND_H_
#define _SURFACECREATECOMMAND_H_

#include "ICommand.h"
#include "PixelFormat.h"
#include "IScene.h"

class SurfaceCreateCommand : public ICommand
{
public:
    /*!
     * \action    This command creates a surface within the GENIVI LayerManagement
     * \frequency Called at least once for all graphical applications, either by
     *            applications themselves or through a management component informed
     *            of a new window by the window management API.
     * \param[in] sender process id of application that sent this command
     * \param[in] sender process id of sender of this command
     * \param[in] idReturn location where surface id will be stored during execution
     *                     pre-initialized value is used as requested surface id
     * \ingroup Commands
     */
    SurfaceCreateCommand(pid_t sender, uint* idReturn)
    : ICommand(ExecuteSynchronous, sender)
    , m_idReturn(idReturn)
    {}

    /**
     * \brief default destructor
     */
    virtual ~SurfaceCreateCommand() {}

    /**
     * \brief Execute this command.
     * \param[in] executor Pointer to instance executing the LayerManagement COmmands
     * \return ExecutionSuccess: execution successful
     * \return ExecutionSuccessRedraw: execution successful and screen needs to be redrawn
     * \return ExecutionFailed: execution failed
     * \return ExecutionFailedRedraw: execution unsuccessful and screen needs to be redrawn
     */
    virtual ExecutionResult execute(ICommandExecutor* executor);

    /**
     * \brief Get description string for this command.
     * \return String object with description of this command object
     */
    virtual const std::string getString();

private:
    uint* m_idReturn;
};


#endif /* _SURFACECREATECOMMAND_H_ */
